#include <stdio.h>

#define MAX_STUDENTS 20

struct Student {
    int id;
    char name[50];
    int age;
    char address[100];
};

int main() {
    struct Student students[MAX_STUDENTS];
    int numStudents, i, searchId;

    printf("Enter the number of students (more than 10): ");
    scanf("%d", &numStudents);

    if (numStudents <= 10) {
        printf("Number of students must be more than 10.\n");
        return 1;
    }
    for (i = 0; i < numStudents; i++) {
        printf("Enter details for student %d:\n", i + 1);
        printf("ID: ");
        scanf("%d", &students[i].id);
        printf("Name: ");
        scanf("%s", students[i].name);
        printf("Age (between 18 to 24): ");
        scanf("%d", &students[i].age);
        if (students[i].age < 18 || students[i].age > 24) {
            printf("Age must be between 18 to 24.\n");
            return 1;
        }
        printf("Address: ");
        scanf("%s", students[i].address);
    }
    printf("Enter the ID of student to search: ");
    scanf("%d", &searchId);

    for (i = 0; i < numStudents; i++) {
        if (students[i].id == searchId) {
            printf("Details of student with ID %d:\n", searchId);
            printf("Name: %s\n", students[i].name);
            printf("Age: %d\n", students[i].age);
            printf("Address: %s\n", students[i].address);
            break;
        }
    }

    if (i == numStudents) {
        printf("Student with ID %d not found.\n", searchId);
    }

    return 0;
}